%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%	MDPI class for LaTeX files	 18 March 2024 pm
%% %%	For any information please send an e-mail to:
%% %%		xiu.li@mdpi.com
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% IDENTIFICATION
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{Definitions/scifiniti_jams}[17/4/2024]

 %% PRELIMINARY DECLARATIONS
\LoadClass[10.5pt]{article}
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
\RequirePackage{fontspec}
\setmainfont{Times New Roman}
\newfontfamily\gsmfont{Gill Sans MT}
\newfontfamily\arialfont{Arial}
%\renewcommand{\sfdefault}{Gill Sans MT}
\RequirePackage{fancyhdr}
\RequirePackage{graphicx,epstopdf}
\RequirePackage{lastpage}
\RequirePackage{ifthen}
\RequirePackage{float}
\RequirePackage{amsmath}
\RequirePackage{amssymb} % For math environment bold format
\RequirePackage{lineno}
\RequirePackage{setspace}
\RequirePackage{enumitem}
\RequirePackage{booktabs} % For \toprule etc. in tables
\RequirePackage{titlesec}
\RequirePackage{etoolbox} % For \AtBeginDocument etc.
\RequirePackage{tabto} % To use tab for alignment on first page
\RequirePackage{xcolor, colortbl} % To provide color for soul (for english editing), for adding cell color of table
\RequirePackage{soul} % To highlight text
\RequirePackage{multirow}
\RequirePackage{microtype} % For command \textls[]{}
\RequirePackage{tikz} % For \foreach used for Orcid icon
\RequirePackage{refcount} % To enable extracting the value of the counter "LastPage" 
\RequirePackage{attrib} % For XML2PDF use \tag{} for equation
\RequirePackage{upgreek} % For making greek letters not italic
\RequirePackage{array} % For table array
\RequirePackage{tabularx}
\RequirePackage{pbox} % For biography environment
\RequirePackage{ragged2e} % For command \justifying
\RequirePackage{marvosym} % Add email mark
\RequirePackage{xstring} % For endnotes
\RequirePackage{enotez} % For endnotes
\RequirePackage{framed} 
\definecolor{shadecolor}{RGB}{242,242,242}
\RequirePackage{cuted}
\RequirePackage{rotating}

%% To choose the journal
% All journals (website name, full name, short name, DOI abbreviation, and ISSN + choice of continuous page numbers) are defined in an extra file. 
\input{Definitions/journalnames}
\DeclareOption{journal}{\ClassWarning{mdpi}{You used an invalid journal name or you have not specified the journal. The first option of the documentclass command specifies the journal.}} 

%% To choose the type of manuscript
\DeclareOption{abstract}{\gdef\@arttype{Abstract}}
\DeclareOption{addendum}{\gdef\@arttype{Addendum}}
\DeclareOption{article}{\gdef\@arttype{Article}}

%% To choose the status of the manuscript
\DeclareOption{submit}{\gdef\@status{submit}}
\DeclareOption{accept}{\gdef\@status{accept}}

%% To choose the whether there is one or more authors
\DeclareOption{oneauthor}{\gdef\@authornum{Author}}
\DeclareOption{moreauthors}{\gdef\@authornum{Authors}}

%% Add the chosen options to the class
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

%% Defaults
\ExecuteOptions{notspecified,10pt,article,submit,oneauthor,twocolumn,twoside}

%% Process options
\ProcessOptions\relax

%% MORE DECLARATIONS

%%%% Maths environments
\RequirePackage{amsthm}
\newtheoremstyle{mdpi}% name
{12pt}% space above
{12pt}% space below
{\itshape}% body font
{}% indent amount 1
{\bfseries}% theorem head font
{.}% punctuation after theorem head
{.5em}% space after theorem head
{}% theorem head spec (can be left empty, meaning `normal')

\renewcommand{\qed}{\unskip\nobreak\quad\qedsymbol} %% This places the symbol right after the text instead of placing it at the end on the line.

\renewenvironment{proof}[1][\proofname]{\par %% \proofname allows to have "Proof of my theorem"
  \pushQED{\qed}%
  \normalfont \topsep6\p@\@plus6\p@\relax
  \trivlist
  \item[\hskip\labelsep
        \bfseries %% "Proof" is bold
    #1\@addpunct{.}]\ignorespaces %% Period instead of colon
}{%
  \popQED\endtrivlist\@endpefalse
}

 \theoremstyle{mdpi}
 \newcounter{theorem}
 \setcounter{theorem}{0}
 \newtheorem{Theorem}[theorem]{Theorem}
 
 \newcounter{lemma}
 \setcounter{lemma}{0}
 \newtheorem{Lemma}[lemma]{Lemma}
 
 \newcounter{corollary}
 \setcounter{corollary}{0}
 \newtheorem{Corollary}[corollary]{Corollary}
 
 \newcounter{proposition}
 \setcounter{proposition}{0}
 \newtheorem{Proposition}[proposition]{Proposition}
 
 \newcounter{characterization}
 \setcounter{characterization}{0}
 \newtheorem{Characterization}[characterization]{Characterization}
 
 \newcounter{property}
 \setcounter{property}{0}
 \newtheorem{Property}[property]{Property}
 
 \newcounter{problem}
 \setcounter{problem}{0}
 \newtheorem{Problem}[problem]{Problem}
 
 \newcounter{example}
 \setcounter{example}{0}
 \newtheorem{Example}[example]{Example}
 
 \newcounter{examplesanddefinitions}
 \setcounter{examplesanddefinitions}{0}
 \newtheorem{ExamplesandDefinitions}[examplesanddefinitions]{Examples and Definitions}
 
 \newcounter{remark}
 \setcounter{remark}{0}
 \newtheorem{Remark}[remark]{Remark}
 
 \newcounter{definition}
 \setcounter{definition}{0}
 \newtheorem{Definition}[definition]{Definition}
 
 \newcounter{hypothesis}
 \setcounter{hypothesis}{0}
 \newtheorem{Hypothesis}[hypothesis]{Hypothesis}

 \newcounter{notation}
 \setcounter{notation}{0}
 \newtheorem{Notation}[notation]{Notation}
 
 \newcounter{assumption}
 \setcounter{assumption}{0}
 \newtheorem{Assumption}[assumption]{Assumption}
 
 \newcounter{algorithm}
 \setcounter{algorithm}{0}
 \newtheorem{Algorithm}[algorithm]{Algorithm}

 % Define left/right mark in math environment
\let\originalleft\left
\let\originalright\right
\renewcommand{\left}{\mathopen{}\mathclose\bgroup\originalleft}
\renewcommand{\right}{\aftergroup\egroup\originalright}
 

%%%% References
\RequirePackage[sort&compress,sectionbib]{natbib} % Option sectionbib is for optionally organizing references using sections (author request)
	\bibpunct{[}{]}{,}{n}{}{,}%

\renewcommand\NAT@set@cites{%
  \ifNAT@numbers
    \ifNAT@super \let\@cite\NAT@citesuper
       \def\NAT@mbox##1{\unskip\nobreak\textsuperscript{##1}}%
       \let\citeyearpar=\citeyear
       \let\NAT@space\relax
       \def\NAT@super@kern{\kern\p@}%
    \else
       \let\NAT@mbox=\mbox
       \let\@cite\NAT@citenum
       \let\NAT@space\relax
       \let\NAT@super@kern\relax
    \fi
    \let\@citex\NAT@citexnum
    \let\@biblabel\NAT@biblabelnum
    \let\@bibsetup\NAT@bibsetnum
    \renewcommand\NAT@idxtxt{\NAT@name\NAT@spacechar\NAT@open\NAT@num\NAT@close}%
    \def\natexlab##1{}%
    \def\NAT@penalty{\penalty\@m}%
  \else
    \let\@cite\NAT@cite
    \let\@citex\NAT@citex
    \let\@biblabel\NAT@biblabel
    \let\@bibsetup\NAT@bibsetup
    \let\NAT@space\NAT@spacechar
    \let\NAT@penalty\@empty
    \renewcommand\NAT@idxtxt{\NAT@name\NAT@spacechar\NAT@open\NAT@date\NAT@close}%
    \def\natexlab##1{##1}%
  \fi}


%%%%% Hyperlinks
%% Define color for citations
\definecolor{artictypecolor}{RGB}{0,38,80}
\definecolor{rulecolor}{RGB}{0,38,80}
\definecolor{framecolor}{RGB}{242,242,242}
\definecolor{headercolor}{RGB}{118,113,113}

% After TeXLive 2021, \AddToHook{begindocument} is needed to make sure that hyperref is loaded last. \ifdef{\AddToHook{begindocument}}{ is needed for backwards-compatibility because \AddToHook{begindocument} did not yet exist in 2020.
% After TeXLive 2022, \AddToHook{begindocument/before}{} is needed and  \DeclareHookRule{begindocument}{hyperref}{before}{mdpi} needs to be added because of the new version of hyperref.
\newcommand{\hyperrefpackage}{
	\RequirePackage[unicode=true,
	bookmarksopen={true},
	pdffitwindow=true, 
	colorlinks=true, 
	linkcolor=red, 
	citecolor=red, 
	urlcolor=red, 
	hyperfootnotes=true, 
	pdfstartview={FitH},
	pdfpagemode= UseNone]{hyperref}
\RequirePackage[capitalise,noabbrev]{cleveref}
}
\ifdef{\AddToHook}{
\DeclareHookRule{begindocument}{hyperref}{before}{mdpi}
	\AddToHook{begindocument/before}{ 
		\hyperrefpackage
		}
	}{
	\hyperrefpackage
}
%% To have the possibility to change the urlcolor
\newcommand{\changeurlcolor}[1]{\hypersetup{urlcolor=#1}} 

%% Cleveref definitions
\newcommand{\cleverefDefinitions}{
	\crefname{figure}{Figure}{Figures}
	\crefname{table}{Table}{Tables}
	\crefname{section}{Section}{Sections}
	\crefname{appendix}{Appendix}{Appendices}
	\crefname{scheme}{Scheme}{Schemes}
	\crefname{chart}{Chart}{Charts}
	\crefname{paragraph}{Section}{Sections}
	\crefrangelabelformat{figure}{##3##1##4--##5##2##6} % double # for nesting inside \newcommand
	\crefrangelabelformat{table}{##3##1##4--##5##2##6}
	\crefrangelabelformat{section}{##3##1##4--##5##2##6}	
	\crefrangelabelformat{appendix}{##3##1##4--##5##2##6}
	\crefrangelabelformat{scheme}{##3##1##4--##5##2##6}
	\crefrangelabelformat{chart}{##3##1##4--##5##2##6}
}

\newcommand{\crefrangeconjunction}{--}
\newcommand{\fig}[1]{Figure~\ref{#1}}
\newcommand{\tabref}[1]{Table~\ref{#1}}
\newcommand{\sect}[1]{Section~\ref{#1}}
\newcommand{\app}[1]{Appendix~\ref{#1}}
\newcommand{\sche}[1]{Scheme~\ref{#1}}
\newcommand{\cchart}[1]{Chart~\ref{#1}}
\newcommand{\equ}[1]{\ref{#1}}
\newcommand{\boxref}[1]{Box~\ref{#1}}%


%%%% Metadata
\newcommand{\org@maketitle}{}% LATEX-Check
\let\org@maketitle\maketitle
\def\maketitle{%
	\hypersetup{
		pdftitle={\@Title},
		pdfsubject={\@abstract},
		pdfkeywords={\@keyword},
		pdfauthor={\@AuthorNames}
	}%
	\org@maketitle
}

%%%%% Endnotes
\setenotez{backref=true,list-name={\vspace{-28pt}}}
\DeclareInstance{enotez-list}{custom}{paragraph}{
	format=\fontsize{10}{10}\selectfont\leftskip0.80cm,
	number=\textsuperscript{#1} \hspace{0.425cm},
	notes-sep=0pt
}

%%%% URL
\RequirePackage{url}
\urlstyle{same}
% Line breaks in URL
\def\UrlDigits{\do\1\do\2\do\3\do\4\do\5\do\6\do\7\do\8\do\9\do\0}
\g@addto@macro{\UrlBreaks}{\UrlOrds}
\g@addto@macro{\UrlBreaks}{\UrlDigits}


%%%% Widows & orphans
\clubpenalty=10000
\widowpenalty=10000
\displaywidowpenalty=10000

%%%% To avoid "Output-loop.." compile bug
\maxdeadcycles=10000

%%%% Front matter
\newcommand{\firstargument}{}
\newcommand{\Title}[1]{\gdef\@Title{#1}}%
\def\@Author{}
\newcommand{\Author}[1]{\gdef\@Author{#1}}%
\def\@AuthorNames{}
\newcommand{\AuthorNames}[1]{\gdef\@AuthorNames{#1}}%
\def\@ShortAuthorName{}
\newcommand{\ShortAuthorName}[1]{\gdef\@ShortAuthorName{#1}}%
\newcommand{\firstpage}[1]{\gdef\@firstpage{#1}}
\newcommand{\doinum}[1]{\gdef\@doinum{#1}}
\newcommand{\pubvolume}[1]{\gdef\@pubvolume{#1}}
\newcommand{\pubyear}[1]{\gdef\@pubyear{#1}}
\newcommand{\copyrightyear}[1]{\gdef\@copyrightyear{#1}}
\newcommand{\address}[2][]{\renewcommand{\firstargument}{#1}\gdef\@address{#2}}
\newcommand{\corresfirstargument}{}
\def\@corres{}
\newcommand{\corres}[2][]{\renewcommand{\corresfirstargument}{#1}\gdef\@corres{#2}} 
\def\@abstract{}
\renewcommand{\abstract}[1]{\gdef\@abstract{#1}}
\def\@datesubmitted{}
\newcommand{\datesubmitted}[1]{\gdef\@datesubmitted{#1}} 
\def\@dateaccepted{}
\newcommand{\dateaccepted}[1]{\gdef\@dateaccepted{#1}} 
\newcommand{\datepublished}[1]{\gdef\@datepublished{#1}} 
\def\@keyword{}
\newcommand{\keyword}[1]{\gdef\@keyword{#1}}
\def\@issuenum{}
\newcommand{\issuenum}[1]{\gdef\@issuenum{#1}}
\def\@firstnote{}
\newcommand{\firstnote}[1]{\gdef\@firstnote{#1}}
\def\@secondnote{}
\newcommand{\secondnote}[1]{\gdef\@secondnote{#1}}%

\def\@externalbibliography{}
\newcommand{\externalbibliography}[1]{\gdef\@externalbibliography{#1}}
\def\@reftitle{}
\newcommand{\reftitle}[1]{\gdef\@reftitle{#1}}

%% ORCID
% Make Orcid icon
\newcommand{\orcidicon}{\includegraphics[width=0.32cm]{Definitions/logo-orcid.pdf}}

% Define link and button for each author
\foreach \x in {A, ..., Z}{%
\expandafter\xdef\csname orcid\x\endcsname{\noexpand\href{https://orcid.org/\csname orcidauthor\x\endcsname}{\noexpand\orcidicon}}
}

%%%% Journal name for the header
\newcommand{\journalname}{\@journalshort}

%%%% Corresponding Author, Article History, Cite This... %%%%
\newcommand{\paperciteinformation}{
\ifthenelse{\equal{\@corres}{\@empty}}{}{%
      \vskip-4.5mm      
	\fontsize{7.0}{7.0}\selectfont\noindent\textbf{\textcolor{headercolor}{* Corresponding Author:}\\}{
       \fontsize{7.0}{7.0}\selectfont\textcolor{headercolor}{\@corres}}
}%10
}

%%%% Header and footer on first page
%% The plain page style needs to be redefined because with \maketitle in the article class, LaTeX applies the the plain page style automatically to the first page.
\fancypagestyle{plain}{%
%			\fancyhf{}
\renewcommand{\headrulewidth}{1.0pt} % headrule width
\renewcommand{\headrule}{\vspace{-6pt}\hbox to\headwidth{\color{black}\leaders\hrule height  \headrulewidth\hfill}}
\renewcommand{\footrulewidth}{1pt}
\lhead{%
		\fontsize{11}{11}\selectfont\arialfont       
            \textbf{\journalname}\\
           \arialfont\fontsize{7.5}{7.5}\selectfont \textcolor{headercolor}{\@pubyear, \ Vol.\ \@pubvolume, \ Cite as: doi:\@doinum}\\\vspace{2pt}
	}

\rhead{\changeurlcolor{black}%
		  \href{https://scifiniti.com/}{\includegraphics[width=3.39 cm]{Definitions/scifiniti logo-02}}}
	
\lfoot{\paperciteinformation}	

\rfoot{\cright}

\cfoot{\arialfont\vspace*{6.5pt}\\\fontsize{8}{8}\selectfont\thepage}
	}%	

%%%% Maketitle part 1: Logo, Arttype, Title, Author
\renewcommand{\@maketitle}{%
             \begin{flushright}
		{%1
   	 	\vspace*{-1.6cm}
    		\fontsize{8}{8}\selectfont
		\colorbox{black}{\textcolor{white}{\boldmath\bfseries\gsmfont{\@arttype}}}
 	   	\par%
    		}%1
	       \end{flushright}
             \begin{flushleft}
	      \begin{spacing}{1}
	      {%3
		\changeurlcolor{black}%
		\href{https://creativecommons.org/}{%
		 \includegraphics[width=1.62 cm]{Definitions/logo-openaccess}}
             \par
   	 	\vspace{-10pt}
	      }%3
	      \end{spacing}
	      \begin{spacing}{1.35}
    		{%1
  	  	\fontsize{20}{20}\selectfont
		\hyphenpenalty=10000
		\tolerance=1000
   	 	{\boldmath\bfseries{\gsmfont\@Title}}
   	 	\par
   	 	\vspace{20pt}
   	 	}%1
   		{%2
		\hyphenpenalty=10000
		\tolerance=1000
    		\boldmath\bfseries{\gsmfont\@Author}
    		\par
             \vspace*{-0.6cm}
    		}%2
	\end{spacing}
	\end{flushleft}
	}

%%%% Commands for hanging indent
\newcommand{\dist}{1.7em}
\newcommand{\hang}{\hangafter=1\hangindent=\dist\noindent}

%%%% Maketitle part 2
\newcommand{\maketitlen}{
	\begin{flushleft}
	\begin{spacing}{1.35}
	\hyphenpenalty=10000
	\tolerance=1000
	\fontsize{8}{8}\selectfont
	{%4
	\ifthenelse{\equal{\firstargument}{1}}{}{%
	\hang}\@address
	\par
	}%4
	{%5
	\ifthenelse{\equal{\@firstnote}{\@empty}}{}{%
	\hang\ifthenelse{\equal{\@firstnote}{\@empty}}{$^\dagger$}{$^\ddagger$} \tabto{\dist} \@firstnote}	
	\par
	}%5
	{%6
	\ifthenelse{\equal{\@secondnote}{\@empty}}{}{%
	\hang \ifthenelse{\equal{\@secondnote}{\@empty}}{$^{\ddagger}$}{$^{\S}$} \tabto{\dist} \@secondnote}
	\par
	\vspace{15pt}
	}%6
	{%7
	\fontsize{9}{9}\selectfont
      \noindent\textbf{\gsmfont Article History\\}
      \begin{tabular}{@{}lcr@{}}
	\begin{minipage}{0.359\textwidth}
	Submitted: \@datesubmitted
	\end{minipage}&
	\begin{minipage}{0.359\textwidth}
	Accepted: \@dateaccepted
	\end{minipage}&
	\begin{minipage}{0.359\textwidth}
	Published: \@datepublished
	\end{minipage}
       \end{tabular}
	\vspace{6pt}
	\par
	}%7
	\end{spacing}
	\rule{\textwidth}{0.5pt}
	\end{flushleft}
 }

%%%% Abstract, keywords, journal data, PACS, MSC, JEL
\newcommand{\abstractkeywords}{
	 \begin{spacing}{1.3}
\fontsize{9}{9}\selectfont
	\vspace{-10pt}
\ifthenelse{\equal{\@abstract}{\@empty}}{}{
	\noindent\textbf{\gsmfont Abstract\\}\@abstract
	\vspace{18pt}
	\par
     }%8
	\rule{\textwidth}{0.5pt}
%11
\ifthenelse{\equal{\@keyword}{\@empty}}{}{
	\noindent\textbf{\gsmfont Keywords:\\}\@keyword
	\par
	\vspace{30pt}
     }%9
	\end{spacing}
\normalsize
}

%%%% Print maketitle and abstractkeywords
	\AfterEndPreamble{%
            \begin{strip}
		\maketitle
		\let\maketitle\relax
		\maketitlen
		\let\maketitlen\relax
		\ifthenelse{\equal{\@status}{submit}}{\linenumbers}{}
                \abstractkeywords
             \end{strip}
	}%
	
\AtBeginDocument{% 
      \emergencystretch0.5em
	\cleverefDefinitions
       \twocolumn       
}


%%%% Font size in Tables and watermark in arttype retraction
\AtEndPreamble{
	\def\@tablesize{}
	\newcommand{\tablesize}[1]{\gdef\@tablesize{#1}}
	\let\oldtabularx\tabularx
	\renewcommand{\tabularx}{\ifthenelse{\equal{\@tablesize}{\@empty}}{\small}{\@tablesize}\oldtabularx}
}


%%%% Section headings
\setcounter{secnumdepth}{4} % Default: 3 in the article class. To get paragraphs numbered and counted, increase the default value of secnumdepth to 4

\titleformat {\section} [block] {\raggedright \fontsize{14}{14}\selectfont\bfseries\gsmfont} {\thesection.\space} {0pt} {}
\titlespacing* {\section} {0pt} {10pt} {10pt}

\titleformat {\subsection} [block] {\raggedright \fontsize{12}{12}\selectfont\bfseries\gsmfont} {\thesubsection.\space} {0pt} {}
\titlespacing* {\subsection} {0pt} {10pt} {10pt}

\titleformat {\subsubsection} [block] {\raggedright \fontsize{10}{10}\selectfont\bfseries\gsmfont} {\thesubsubsection.\space} {0pt} {}
\titlespacing* {\subsubsection} {0pt} {10pt} {10pt}

\titleformat {\paragraph} [block] {\raggedright \fontsize{10}{10}\selectfont\gsmfont} {} {0pt} {}
\titlespacing* {\paragraph} {0pt} {10pt} {10pt}


%%%% Special section title style for back matter
\newcommand{\supplementary}[1]{
\par\vspace{6pt}\noindent{\fontsize{9}{11.5}\selectfont\textbf{Supplementary Materials:} {#1}\par}}

\newcommand{\authorcontributions}[1]{%
\vspace{6pt}\noindent{\fontsize{9}{11.2}\selectfont\textbf{Author Contributions:} {#1}\par}}

\newcommand{\funding}[1]{
\vspace{6pt}\noindent{\fontsize{9}{11.2}\selectfont\textbf{Funding:} {#1}\par}}


%%%%% Defines the appendix
\def\@appendixtitles{}
\newcommand{\appendixtitles}[1]{\gdef\@appendixtitles{#1}}

\def\@appendixsections{}
\newcommand{\appendixsections}[1]{\gdef\@appendixsections{#1}}

\def\@appendixstart{}
\newcommand{\appendixstart}[1]{\gdef\@appendixstart{#1}}

\renewcommand{\appendixstart}{%
\setcounter{section}{0}%
\setcounter{subsection}{0}%
\setcounter{subsubsection}{0}%
\setcounter{figure}{0}
\setcounter{table}{0}
\setcounter{scheme}{0}
\setcounter{chart}{0}
\setcounter{boxenv}{0}
\setcounter{equation}{0}
\setcounter{theorem}{0}
\setcounter{lemma}{0}
\setcounter{corollary}{0}
\setcounter{proposition}{0} 
\setcounter{characterization}{0} 
\setcounter{property}{0} 
\setcounter{problem}{0} 
\setcounter{example}{0} 
\setcounter{examplesanddefinitions}{0} 
\setcounter{remark}{0} 
\setcounter{definition}{0} 
\setcounter{hypothesis}{0}
\setcounter{notation}{0}
\setcounter{algorithm}{0}
}

\renewcommand{\appendix}{%
%
\gdef\thesection{\@Alph\c@section}%
\gdef\thesubsection{\@Alph\c@section.\@arabic\c@subsection}%

\titleformat {\section} [block] {\raggedright\bfseries} {%
	\ifthenelse{\equal{\@appendixtitles}{yes}}{%
		\appendixname~\thesection.%
		}{%
		\appendixname~\thesection~%
		}
	} {0pt} {}
\titlespacing {\section} {0pt} {10pt} {10pt}
%
\titleformat {\subsection} [block] {\raggedright\itshape} {%
	\ifthenelse{\equal{\@appendixtitles}{yes}}{%
		\appendixname~\thesubsection.%
		}{%
		\appendixname~\thesubsection%
		}
	} {0pt} {}
\titlespacing {\section} {0pt} {10pt} {10pt}
%
\titleformat {\subsubsection} [block] {\raggedright\selectfont} {%
	\ifthenelse{\equal{\@appendixtitles}{yes}}{%
		\appendixname~\thesubsubsection.%
		}{%
		\appendixname~\thesubsubsection%
		}
	} {0pt} {}
\titlespacing {\section} {0pt} {10pt} {10pt}
%
\gdef\theHsection{\@Alph\c@section.}% for hyperref
\gdef\theHsubsection{\@Alph\c@section.\@arabic\c@subsection}% for hyperref
\csname appendixmore\endcsname
\renewcommand{\thefigure}{A\arabic{figure}}
\renewcommand{\thetable}{A\arabic{table}}
\renewcommand{\thescheme}{A\arabic{scheme}}
\renewcommand{\thechart}{A\arabic{chart}}
\renewcommand{\theboxenv}{A\arabic{boxenv}}
\renewcommand{\theequation}{A\arabic{equation}}
\renewcommand{\thetheorem}{A\arabic{theorem}}
\renewcommand{\thelemma}{A\arabic{lemma}}
\renewcommand{\thecorollary}{A\arabic{corollary}}
\renewcommand{\theproposition}{A\arabic{proposition}} 
\renewcommand{\thecharacterization}{A\arabic{characterization}}
\renewcommand{\theproperty}{A\arabic{property}}
\renewcommand{\theproblem}{A\arabic{problem}}
\renewcommand{\theexample}{A\arabic{example}}
\renewcommand{\theexamplesanddefinitions}{A\arabic{examplesanddefinitions}}
\renewcommand{\theremark}{A\arabic{remark}}
\renewcommand{\thedefinition}{A\arabic{definition}}
\renewcommand{\thehypothesis}{A\arabic{hypothesis}}
\renewcommand{\thenotation}{A\arabic{notation}}
\renewcommand{\thealgorithm}{A\arabic{algorithm}}
}


%%%% Layout
\RequirePackage[left=2.54cm, 
				right=2.54cm,
				top=1.0cm,
				bottom=1.5cm,
				footskip=24pt,
				headsep=30pt,
				paperwidth=21.59cm,
				paperheight=27.94cm,
				includehead,
				includefoot]{geometry}

\linespread{1.055} 
\setlength{\parindent}{0.8cm}
\setlength\columnsep{0.4cm}

%%%% Commands for landscape page
\newcommand{\startlandscape}{
	\clearpage
	\paperwidth=\pdfpageheight
	\paperheight=\pdfpagewidth
	\pdfpageheight=\paperheight
	\pdfpagewidth=\paperwidth
	\newgeometry{layoutwidth=27.94cm, layoutheight=21.59cm, left=2.54cm, right=2.54cm, top=1.0cm, bottom=1.5cm, includehead, includefoot}
	\fancyheadoffset{0pt}
	}

\newcommand{\finishlandscape}{
	\clearpage
	\paperwidth=\pdfpageheight
	\paperheight=\pdfpagewidth
	\pdfpageheight=\paperheight
	\pdfpagewidth=\paperwidth
	\restoregeometry
	\fancyheadoffset[L]{\textwidth}
}


%%%% Figures and tables
\RequirePackage{newfloat}
\DeclareFloatingEnvironment[]{listing}
\DeclareFloatingEnvironment[name=Box]{boxenv}	
\DeclareFloatingEnvironment[]{chart}
\DeclareFloatingEnvironment[]{scheme}
\DeclareFloatingEnvironment[]{figurewide}

\RequirePackage{caption}
\captionsetup[figure]{position=top, 	labelfont={bf, footnotesize,sf}, labelsep=colon, textfont={footnotesize,sf}, aboveskip=6pt, belowskip=-6pt, singlelinecheck=off, justification=justified,name=\gsmfont Figure}

\captionsetup[scheme]{position=top,	labelfont={bf, footnotesize,sf}, labelsep=colon, textfont={footnotesize,sf}, aboveskip=6pt, belowskip=-6pt, singlelinecheck=off, justification=justified,name=\gsmfont Scheme}

\captionsetup[table]{position=top,     labelfont={bf, footnotesize,sf}, labelsep=colon, textfont={footnotesize,sf}, aboveskip=6pt, singlelinecheck=off, justification=justified,name=\gsmfont Table}

%% For table footnotes
\newsavebox{\@justcentbox}
\newcommand{\justifyorcenter}[1]{
\sbox \@justcentbox{#1}
\ifdim \wd \@justcentbox >\hsize #1
\else \centerline{#1} \fi
}

%%%% Bullet lists
\setitemize{topsep=3pt,parsep=0pt,itemsep=0pt,leftmargin=*,labelsep=7.25mm,align=parleft}
\setenumerate{topsep=3pt,parsep=0pt,itemsep=0pt,leftmargin=*,labelsep=5.75mm,align=parleft}
\setlist[description]{itemsep=0mm}

%%%% Quote environment
\renewenvironment{quote}{
	\list{}{
		\listparindent=0pt
		\leftmargin=0.0cm
		\rightmargin=0.7cm
		\topsep=5pt
		\parsep=5pt
	}%
	\item\relax
	}
	{\endlist}

%%%%% Header and footer (all pages except the first)
\renewcommand{\headrulewidth}{1.0pt} % rulewidth
\renewcommand{\headrule}{\vspace{-6pt}\hbox to\headwidth{\color{black}\leaders\hrule height \headrulewidth\hfill}}\renewcommand{\footrulewidth}{1pt}
\pagestyle{fancy}
\fancyhead[EL,OR]{%
	      \fontsize{7.5}{7.5}\selectfont\arialfont \textcolor{headercolor}{        
            \@pubyear, \ Vol.\ \@pubvolume, \ Issue \@issuenum}\\
            \arialfont \textcolor{headercolor}{doi:\@doinum}\\\vspace{2pt}}
		\fancyhead[ER,OL]{%
			\changeurlcolor{black}%
			\href{https://scifiniti.com/}{\includegraphics[width=3.5 cm]{Definitions/scifiniti logo-02}}}
        	\fancyfoot[EL,OR]{%
                   \fontsize{7.5}{7.5}\selectfont\arialfont
	            \@ShortAuthorName}
        	\fancyfoot[ER,OL]{%
        	      \fontsize{10}{10}\selectfont\arialfont       
                   \textbf{\journalname}}
        	\fancyfoot[C]{\arialfont\vspace*{6.5pt}\\\fontsize{8}{8}\selectfont\thepage}	


%%%% Bibliography
\renewcommand\bibname{References} % Backwards compatibility for book production
\renewcommand\@biblabel[1]{[#1]\hfill}
\def\thebibliography#1{
\emergencystretch 2em
\titleformat {\section} [block] {\raggedright \fontsize{12}{12}\selectfont\bfseries\gsmfont} {} {0pt} {}
\section{\@reftitle}
\fontsize{10}{10}\selectfont
\list{{\arabic{enumi}}}{\def\makelabel##1{\hss{##1}}
\topsep=0\p@
\parsep=1\p@
\partopsep=0\p@
\itemsep=1\p@
\labelsep=0.55mm
\itemindent=0mm
\settowidth\labelwidth{\footnotesize[#1]}%
\leftmargin\labelwidth
\advance\leftmargin\labelsep
%\advance\leftmargin -\itemindent
\usecounter{enumi}}
%\def\newblock{\ }
%\sloppy\clubpenalty4000\widowpenalty4000
%\sfcode`\.=1000\relax
}
\let\endthebibliography=\endlist

%%%% Copyright info
\newcommand{\cright}{%
\setlength\tabcolsep{3pt}
\begin{tabular}[t]{@{}p{1.0cm}p{6.75cm}}%{0.48\textwidth}
			\changeurlcolor{black}%
			\href{https://creativecommons.org/licenses/by/4.0/}{%
			\includegraphics[height=0.38 cm]{Definitions/logo-ccby}}&
			\pbox{0.4\textwidth}{%
                  \fontsize{7.0}{7}\selectfont\textcolor{headercolor}{
                  \copyright{} {\@ \the\year} Copyright by the \@authornum.}\\ %
			\textcolor{headercolor}{Licensed as an open access article using a CC BY 4.0 license.}}\\
			&\\
\end{tabular}
	}

	
%%%% For tables XML2PDF
\RequirePackage{seqsplit} % Use for split table column
  \newlength{\cellWidtha}
  \newlength{\cellWidthb}
  \newlength{\cellWidthc}
  \newlength{\cellWidthd}
  \newlength{\cellWidthe}
  \newlength{\cellWidthf}
  \newlength{\cellWidthg}
  \newlength{\cellWidthh}
  \newlength{\cellWidthi}
  \newlength{\cellWidthj}
  \newlength{\cellWidthk}
  \newlength{\cellWidthl}
  \newlength{\cellWidthm}
  \newlength{\cellWidthn}
  \newlength{\cellWidtho}
  \newlength{\cellWidthp}
  \newlength{\cellWidthq}
  \newlength{\cellWidthr}
  \newlength{\cellWidths}
  \newlength{\cellWidtht}
  \newlength{\cellWidthu}
  \newlength{\cellWidthv}
  \newlength{\cellWidthw}
  \newlength{\cellWidthx}
  \newlength{\cellWidthy}
  \newlength{\cellWidthz}
  \newlength{\cellWidthA}
  \newlength{\cellWidthB}
  \newlength{\cellWidthC}
  \newlength{\cellWidthD}
  \newlength{\cellWidthE}
  \newlength{\cellWidthF}
  \newlength{\cellWidthG}
  \newlength{\cellWidthH}
  \newlength{\cellWidthI}
  \newlength{\cellWidthJ}
  \newlength{\cellWidthK}
  \newlength{\cellWidthL}
  \newlength{\cellWidthM}
  \newlength{\cellWidthN}
  \newlength{\cellWidthO}
  \newlength{\cellWidthP}
  \newlength{\cellWidthQ}
  \newlength{\cellWidthR}
  \newlength{\cellWidthS}
  \newlength{\cellWidthT}
  \newlength{\cellWidthU}
  \newlength{\cellWidthV}
  \newlength{\cellWidthW}
  \newlength{\cellWidthX}
  \newlength{\cellWidthY}
  \newlength{\cellWidthZ}
 \newcommand{\PreserveBackslash}[1]{\let\temp=\\#1\let\\=\temp} % For table column setting in XML2PDF

\endinput